﻿// ================================================================================================
// Copyright (c) 2012 All Rights Reserved
// Licensed Materials - Property of Zero One
// 
// (c) Copyright Zero One SAS - 2025
// ================================================================================================

using UnityEngine;
using Random = UnityEngine.Random;

public class ShakeMeRandom : ShakeMe
{
    [Header("Random")]
    public float Duration = .5f;

    public float MinDelay = 1f;
    public float MaxDelay = 3f;

    // --------------------------------------------------------------------------------------------
    private bool isShaking;
    private float nextShakeTime;
    private float shakeEndTime;

    // --------------------------------------------------------------------------------------------
    private void Start()
    {
        ScheduleNextShake();
    }

    // --------------------------------------------------------------------------------------------
    private void Update()
    {
        if (isShaking)
        {
            if (Time.time < shakeEndTime) return;

            isShaking = false;
            ScheduleNextShake();
        }
        else
        {
            if (Time.time < nextShakeTime) return;

            isShaking = true;
            shakeEndTime = Time.time + Duration;
        }
    }

    // --------------------------------------------------------------------------------------------
    private new void FixedUpdate()
    {
        if (isShaking)
        {
            base.FixedUpdate();
        }
        else
        {
            transform.localRotation = Quaternion.identity;
        }
    }

    // --------------------------------------------------------------------------------------------
    private void OnDisable()
    {
        // When disable component reset rotation
        transform.localRotation = Quaternion.identity;
    }

    // --------------------------------------------------------------------------------------------
    private void ScheduleNextShake()
    {
        nextShakeTime = Time.time + Random.Range(MinDelay, MaxDelay);
    }

    // --------------------------------------------------------------------------------------------
}